/** @file   CreditsViewer.h
 * @brief   Declaration of CreditsViewer class.
 * @version $Revision: 1.1 $
 * @date    $Date: 2006/05/30 14:54:46 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_CREDITSVIEWER_H
#define H_WWW_CREDITSVIEWER_H


struct BITMAP;
namespace eng2d {
  class MP3File;
};

namespace WeWantWar {
  
/** @class  CreditsViewer
 * @brief   Shows the game credits
 * @author  Tomi Lamminsaari
 */
class CreditsViewer
{
public: // Constructors, destructor, operators
  /** Constructor.
   */
  CreditsViewer();
  
  /** Destructor.
   */
  virtual ~CreditsViewer();

private:
  CreditsViewer( const CreditsViewer& aAnother );
  CreditsViewer& operator = ( const CreditsViewer& aAnother );
public: // Methods from base classes

public: // New methods

  /** Shows the credits.
   */
  void showCredits();

private:  // private methods
  /** Loads the graphics needed by this view.
   * @return  Nonezero if fails.
   */
  int initViewer();
private:  // members
  /** The scroller graphics */
  BITMAP* iScrollGfx;
  /** Scrolling bitmap's upper edge y */
  float iScrollPosTop;
  /** Scrolling bitmap's lower edge y */
  float iScrollPosBottom;
  /** Scrolling speed. */
  float iScrollSpeed;
  /** Mp3 file being played. */
  eng2d::MP3File* iBackgroundMusic;
};

};  // end of namespace

#endif
